// Data contoh
var data = [];

// Ambil elemen dropdown, search box, dan tabel
const searchInput = document.getElementById("searchInput");
const tbody = document.querySelector("#dataTable tbody");

let debounceTimeout;

async function getList() {
    const response = await fetch('devices.json');
    data = await response.json();
    await updateTable();
}

// Fungsi untuk update tabel
async function updateTable(selectedModel = "", searchTerm = "") {
    tbody.innerHTML = ""; // Hapus isi tabel sebelum update
    
    let filteredData = data.filter(item => {
        const matchModel = selectedModel ? item.model === selectedModel : true;
        const matchSearch = searchTerm
            ? item.model.toLowerCase().includes(searchTerm) ||
              item.variants.toLowerCase().includes(searchTerm) ||
              item.support.toLowerCase().includes(searchTerm)
            : true;
        return matchModel && matchSearch;
    });

    // Tampilkan hasil di tabel atau Not Found jika tidak ada hasil
    if (filteredData.length > 0) {
        filteredData.forEach(item => {
            // Tentukan apakah background merah atau tidak
            let rowClass = item.support.toLowerCase() == 'no' ? 'red-background' : '';
            
            let row = `<tr class="${rowClass}">
                <td>${item.model}</td>
                <td>${item.variants}</td>
                <td>${item.support}</td>
            </tr>`;
            tbody.innerHTML += row;
        });
    } else {
        let notFoundRow = `<tr id="notFoundRow">
            <td colspan="3" style="text-align:center;">Not Found</td>
        </tr>`;
        tbody.innerHTML = notFoundRow;
    }
}

// Debouncing function
function debounce(func, delay) {
    return function (...args) {
        clearTimeout(debounceTimeout);
        debounceTimeout = setTimeout(() => {
            func.apply(this, args);
        }, delay);
    };
}

// Event listener untuk search box dengan debouncing
searchInput.addEventListener("input", debounce(async function() {
    await updateTable("", this.value.toLowerCase()); // Reset dropdown agar bisa auto-update
}, 500));  // 500 ms delay setelah pengguna berhenti mengetik

// Tampilkan semua data saat pertama kali load
getList();
